// data-products.js
// Data produk telah diperbarui dengan 40 item, varian yang lebih beragam, struktur brand yang lebih dalam, dan gambar yang terverifikasi.

export const products = [
  // --- Kategori Makanan ---
  {
    "id": 1,
    "name": "Nasi Goreng Istimewa",
    "brand": "Koki Hebat / Masakan Asia",
    "basePrice": 35000,
    "category": "Makanan / Nasi",
    "isBestSeller": true,
    "description": "Porsi besar nasi goreng dengan telur, ayam, dan sayuran segar.",
    "variants": [ { "id": "1-default", "stock": 46, "image": "https://images.pexels.com/photos/723198/pexels-photo-723198.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" } ],
    "addons": [],
    "condimentGroups": [
      { "id": "condiment-1-1", "title": "Tingkat Pedas", "type": "radio", "isRequired": true, "options": [ { "name": "Tidak Pedas", "price": 0 }, { "name": "Sedang", "price": 0 }, { "name": "Sangat Pedas", "price": 0 } ] },
      { "id": "condiment-1-2", "title": "Pilihan Tambahan", "type": "checkbox", "isRequired": false, "options": [ { "name": "Ekstra Telur", "price": 4000 }, { "name": "Ekstra Ayam", "price": 7000 } ] }
    ]
  },
  {
    "id": 100,
    "name": "Sirloin Steak",
    "brand": "Koki Hebat / Masakan Barat",
    "basePrice": 150000,
    "category": "Makanan / Daging",
    "isBestSeller": true,
    "description": "200gr daging Sirloin premium dengan saus dan pendamping pilihanmu.",
    "variants": [ { "id": "100-default", "stock": 25, "image": "https://images.pexels.com/photos/3220617/pexels-photo-3220617.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" } ],
    "addons": [ { "id": "addon-100-1", "name": "Extra Mushroom Sauce", "price": 15000 } ],
    "condimentGroups": [
      { "id": "condiment-100-1", "title": "Tingkat Kematangan", "type": "radio", "isRequired": true, "options": [ { "name": "Rare", "price": 0 }, { "name": "Medium Rare", "price": 0 }, { "name": "Medium", "price": 0 }, { "name": "Well Done", "price": 0 } ] },
      { "id": "condiment-100-2", "title": "Pilihan Saus", "type": "radio", "isRequired": true, "options": [ { "name": "Mushroom", "price": 0 }, { "name": "Blackpepper", "price": 0 } ] },
      { "id": "condiment-100-3", "title": "Lauk Pendamping", "type": "radio", "isRequired": true, "options": [ { "name": "French Fries", "price": 0 }, { "name": "Potato Wedges", "price": 0 } ] }
    ]
  },
  {
    "id": 109,
    "name": "Classic Pepperoni Pizza",
    "brand": "Koki Hebat / Masakan Barat",
    "basePrice": 85000,
    "category": "Makanan / Pizza",
    "isBestSeller": true,
    "description": "Pizza dengan topping pepperoni sapi dan keju mozzarella melimpah.",
    "variants": [
        { "id": "109-Medium", "size": "Medium (8 potong)", "stock": 20, "image": "https://images.pexels.com/photos/1146760/pexels-photo-1146760.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
        { "id": "109-Large", "size": "Large (12 potong)", "stock": 15, "image": "https://images.pexels.com/photos/1146760/pexels-photo-1146760.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" }
    ], "addons": [ { "id": "addon-109-1", "name": "Extra Cheese", "price": 15000 } ], "condimentGroups": []
  },
    {
    "id": 113,
    "name": "Spaghetti Carbonara",
    "brand": "Koki Hebat / Masakan Barat",
    "basePrice": 75000,
    "category": "Makanan / Pasta",
    "description": "Spaghetti dengan saus telur, keju, dan smoked beef yang creamy.",
    "variants": [ { "id": "113-default", "stock": 28, "image": "https://images.pexels.com/photos/1438672/pexels-photo-1438672.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" } ],
    "addons": [ { "id": "addon-113-1", "name": "Extra Smoked Beef", "price": 12000 } ], "condimentGroups": []
  },
  {
    "id": 117,
    "name": "Beef Burger Deluxe",
    "brand": "Koki Hebat / Masakan Barat",
    "basePrice": 65000,
    "category": "Makanan / Burger",
    "description": "Burger dengan 150gr patty sapi, selada, tomat, dan saus spesial.",
    "variants": [ { "id": "117-default", "stock": 33, "image": "https://images.pexels.com/photos/1639557/pexels-photo-1639557.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" } ],
    "addons": [ { "id": "addon-117-1", "name": "Extra Patty", "price": 25000 }, { "id": "addon-117-2", "name": "Extra Cheese", "price": 10000 } ], "condimentGroups": []
  },
  {
    "id": 9,
    "name": "Ayam Geprek Krispi",
    "brand": "Koki Hebat / Masakan Indonesia",
    "basePrice": 28000,
    "category": "Makanan / Ayam",
    "isBestSeller": true,
    "description": "Ayam geprek dengan sambal pedas dan kulit krispi.",
    "variants": [ { "id": "9-default", "stock": 38, "image": "https://images.pexels.com/photos/10773836/pexels-photo-10773836.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" } ],
    "addons": [],
    "condimentGroups": [
      { "id": "condiment-9-1", "title": "Level Pedas", "type": "radio", "isRequired": true, "options": [ { "name": "Level 1", "price": 0 }, { "name": "Level 2", "price": 0 }, { "name": "Level 3 (Super Pedas)", "price": 2000 } ] },
      { "id": "condiment-9-2", "title": "Tambahan", "type": "checkbox", "isRequired": false, "options": [ { "name": "Keju Parut", "price": 5000 }, { "name": "Kol Goreng", "price": 3000} ] }
    ]
  },
  {
    "id": 201,
    "name": "Sushi Platter",
    "brand": "Koki Hebat / Masakan Asia",
    "basePrice": 125000,
    "category": "Makanan / Sushi",
    "isBestSeller": true,
    "description": "Berbagai macam sushi segar pilihan chef: salmon, tuna, dan tamago.",
    "variants": [
      { "id": "201-regular", "size": "Regular (12 pcs)", "stock": 20, "image": "https://images.pexels.com/photos/8118671/pexels-photo-8118671.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
      { "id": "201-large", "size": "Large (24 pcs)", "stock": 10, "image": "https://images.pexels.com/photos/8118671/pexels-photo-8118671.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" }
    ],
    "addons": [ { "id": "addon-201-1", "name": "Extra Ginger & Wasabi", "price": 5000 } ], "condimentGroups": []
  },

  // --- Kategori Minuman ---
  {
    "id": 108,
    "name": "Iced Caramel Macchiato",
    "brand": "Fresh Brews / Kopi",
    "basePrice": 38000,
    "category": "Minuman / Kopi",
    "description": "Perpaduan espresso, susu, dan saus karamel yang menyegarkan.",
    "variants": [ { "id": "108-default", "stock": 50, "image": "https://images.pexels.com/photos/2905933/pexels-photo-2905933.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" } ],
    "addons": [ { "id": "addon-108-1", "name": "Extra Shot Espresso", "price": 8000 } ],
    "condimentGroups": [
      { "id": "condiment-108-1", "title": "Pilihan Susu", "type": "radio", "isRequired": true, "options": [ { "name": "Fresh Milk", "price": 0 }, { "name": "Oat Milk", "price": 5000 }, { "name": "Soy Milk", "price": 5000 } ] }
    ]
  },
    {
    "id": 111,
    "name": "Matcha Latte",
    "brand": "Fresh Brews / Teh",
    "basePrice": 35000,
    "category": "Minuman / Teh",
    "isBestSeller": true,
    "description": "Teh hijau matcha premium dari Jepang dengan steamed milk lembut.",
    "variants": [
      { "id": "111-Hot", "temp": "Panas", "stock": 30, "image": "https://images.pexels.com/photos/1363920/pexels-photo-1363920.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
      { "id": "111-Cold", "temp": "Dingin", "stock": 35, "image": "https://images.pexels.com/photos/1363920/pexels-photo-1363920.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" }
    ], "addons": [], "condimentGroups": []
  },
  {
    "id": 115,
    "name": "Air Mineral",
    "brand": "Fresh Brews / Lainnya",
    "basePrice": 5000,
    "category": "Minuman",
    "description": "Air mineral murni dari sumber pegunungan terpilih.",
    "variants": [ { "id": "115-default", "stock": 100, "image": "https://images.pexels.com/photos/327090/pexels-photo-327090.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" } ], "addons": [], "condimentGroups": []
  },
  {
    "id": 202,
    "name": "Jus Jeruk Segar",
    "brand": "Fresh Brews / Jus",
    "basePrice": 22000,
    "category": "Minuman / Jus",
    "description": "100% perasan jeruk asli tanpa tambahan gula.",
    "variants": [ { "id": "202-default", "stock": 60, "image": "https://images.pexels.com/photos/1337825/pexels-photo-1337825.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" } ],
    "addons": [],
    "condimentGroups": [
      { "id": "condiment-202-1", "title": "Tingkat Manis", "type": "radio", "isRequired": false, "options": [ { "name": "Tanpa Gula", "price": 0 }, { "name": "Sedikit Gula", "price": 0 }, { "name": "Normal", "price": 0 } ] }
    ]
  },
  {
    "id": 203,
    "name": "Boba Brown Sugar",
    "brand": "Fresh Brews / Teh",
    "basePrice": 28000,
    "category": "Minuman / Teh",
    "isBestSeller": true,
    "description": "Minuman teh susu dengan boba kenyal dan saus gula aren.",
    "variants": [ { "id": "203-default", "stock": 70, "image": "https://images.pexels.com/photos/5946645/pexels-photo-5946645.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" } ],
    "addons": [ { "id": "addon-203-1", "name": "Extra Boba", "price": 5000 } ],
    "condimentGroups": []
  },

  // --- Kategori Fashion ---
  {
    "id": 101,
    "name": "Sneakers Klasik '85",
    "brand": "Urban Threads / Sneakers",
    "basePrice": 1850000,
    "category": "Fashion / Sepatu",
    "isBestSeller": true,
    "description": "Sneaker ikonik dengan desain timeless, wajib punya untuk kolektor.",
    "variants": [
      { "id": "101-Bred-40", "color": "Bred Toe", "size": "40", "stock": 5, "image": "https://images.pexels.com/photos/1040548/pexels-photo-1040548.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
      { "id": "101-Bred-41", "color": "Bred Toe", "size": "41", "stock": 4, "image": "https://images.pexels.com/photos/1040548/pexels-photo-1040548.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
      { "id": "101-Bred-42", "color": "Bred Toe", "size": "42", "stock": 2, "image": "https://images.pexels.com/photos/1040548/pexels-photo-1040548.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
      { "id": "101-Royal-41", "color": "Royal Blue", "size": "41", "stock": 3, "image": "https://images.pexels.com/photos/2385477/pexels-photo-2385477.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
      { "id": "101-Royal-42", "color": "Royal Blue", "size": "42", "stock": 5, "image": "https://images.pexels.com/photos/2385477/pexels-photo-2385477.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
      { "id": "101-Shadow-43", "color": "Shadow Grey", "size": "43", "stock": 6, "image": "https://images.pexels.com/photos/2529148/pexels-photo-2529148.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
      { "id": "101-Panda-42", "color": "Panda White", "size": "42", "stock": 0, "image": "https://images.pexels.com/photos/19090/pexels-photo.jpg?auto=compress&cs=tinysrgb&w=500&h=500" },
      { "id": "101-Panda-44", "color": "Panda White", "size": "44", "stock": 8, "image": "https://images.pexels.com/photos/19090/pexels-photo.jpg?auto=compress&cs=tinysrgb&w=500&h=500" }
    ], "addons": [], "condimentGroups": []
  },
  {
    "id": 110,
    "name": "T-Shirt Katun Premium",
    "brand": "Urban Threads / Casual",
    "basePrice": 150000,
    "category": "Fashion / Atasan",
    "description": "Kaos katun premium yang sangat nyaman untuk dipakai sehari-hari.",
    "variants": [
      { "id": "110-White-S", "color": "Putih", "size": "S", "stock": 15, "image": "https://images.pexels.com/photos/991509/pexels-photo-991509.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
      { "id": "110-White-M", "color": "Putih", "size": "M", "stock": 25, "image": "https://images.pexels.com/photos/991509/pexels-photo-991509.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
      { "id": "110-White-L", "color": "Putih", "size": "L", "stock": 20, "image": "https://images.pexels.com/photos/991509/pexels-photo-991509.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
      { "id": "110-Black-M", "color": "Hitam", "size": "M", "stock": 22, "image": "https://images.pexels.com/photos/1040945/pexels-photo-1040945.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
      { "id": "110-Black-L", "color": "Hitam", "size": "L", "stock": 18, "image": "https://images.pexels.com/photos/1040945/pexels-photo-1040945.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
      { "id": "110-Black-XL", "color": "Hitam", "size": "XL", "stock": 10, "image": "https://images.pexels.com/photos/1040945/pexels-photo-1040945.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
      { "id": "110-Navy-L", "color": "Navy Blue", "size": "L", "stock": 12, "image": "https://images.pexels.com/photos/532292/pexels-photo-532292.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
      { "id": "110-Gray-M", "color": "Abu Misty", "size": "M", "stock": 30, "image": "https://images.pexels.com/photos/220453/pexels-photo-220453.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" }
    ], "addons": [], "condimentGroups": []
  },
   {
    "id": 114,
    "name": "Hoodie Polos",
    "brand": "Urban Threads / Outerwear",
    "basePrice": 250000,
    "category": "Fashion / Atasan",
    "description": "Hoodie bahan fleece tebal yang hangat dan stylish.",
    "variants": [
      { "id": "114-Gray-L", "color": "Abu-abu", "size": "L", "stock": 15, "image": "https://images.pexels.com/photos/573095/pexels-photo-573095.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
      { "id": "114-Gray-XL", "color": "Abu-abu", "size": "XL", "stock": 10, "image": "https://images.pexels.com/photos/573095/pexels-photo-573095.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
      { "id": "114-Navy-M", "color": "Navy", "size": "M", "stock": 18, "image": "https://images.pexels.com/photos/2049363/pexels-photo-2049363.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
      { "id": "114-Navy-L", "color": "Navy", "size": "L", "stock": 12, "image": "https://images.pexels.com/photos/2049363/pexels-photo-2049363.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" }
    ], "addons": [], "condimentGroups": []
  },
  {
    "id": 118,
    "name": "Kemeja Flanel",
    "brand": "Urban Threads / Outerwear",
    "basePrice": 280000,
    "category": "Fashion / Atasan",
    "isBestSeller": true,
    "description": "Kemeja flanel lengan panjang dengan motif kotak-kotak.",
    "variants": [
      { "id": "118-Red-M", "color": "Merah-Hitam", "size": "M", "stock": 14, "image": "https://images.pexels.com/photos/769749/pexels-photo-769749.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
      { "id": "118-Red-L", "color": "Merah-Hitam", "size": "L", "stock": 10, "image": "https://images.pexels.com/photos/769749/pexels-photo-769749.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
      { "id": "118-Green-M", "color": "Hijau-Biru", "size": "M", "stock": 12, "image": "https://images.pexels.com/photos/3763847/pexels-photo-3763847.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" }
    ], "addons": [], "condimentGroups": []
  },
  {
    "id": 204,
    "name": "Celana Chino Slim Fit",
    "brand": "Urban Threads / Casual",
    "basePrice": 320000,
    "category": "Fashion / Bawahan",
    "description": "Celana chino modern dengan potongan slim fit yang serbaguna.",
    "variants": [
      { "id": "204-Khaki-30", "color": "Khaki", "size": "30", "stock": 15, "image": "https://images.pexels.com/photos/1082528/pexels-photo-1082528.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
      { "id": "204-Khaki-32", "color": "Khaki", "size": "32", "stock": 20, "image": "https://images.pexels.com/photos/1082528/pexels-photo-1082528.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
      { "id": "204-Khaki-34", "color": "Khaki", "size": "34", "stock": 12, "image": "https://images.pexels.com/photos/1082528/pexels-photo-1082528.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
      { "id": "204-Black-32", "color": "Hitam", "size": "32", "stock": 18, "image": "https://images.pexels.com/photos/52573/pants-trousers-men-fashion-52573.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
      { "id": "204-Olive-31", "color": "Olive Green", "size": "31", "stock": 14, "image": "https://images.pexels.com/photos/1598507/pexels-photo-1598507.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" }
    ], "addons": [], "condimentGroups": []
  },
  {
    "id": 205,
    "name": "Jaket Bomber",
    "brand": "Urban Threads / Outerwear",
    "basePrice": 450000,
    "category": "Fashion / Atasan",
    "description": "Jaket bomber ringan dengan lapisan dalam yang nyaman.",
    "variants": [
      { "id": "205-Black-L", "color": "Hitam", "size": "L", "stock": 9, "image": "https://images.pexels.com/photos/1124466/pexels-photo-1124466.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
      { "id": "205-Green-M", "color": "Army Green", "size": "M", "stock": 11, "image": "https://images.pexels.com/photos/1183266/pexels-photo-1183266.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" }
    ], "addons": [], "condimentGroups": []
  },
  {
    "id": 206,
    "name": "Performance Jogger",
    "brand": "Urban Threads / Active",
    "basePrice": 380000,
    "category": "Fashion / Bawahan",
    "isBestSeller": true,
    "description": "Celana jogger atletis yang ringan dan fleksibel untuk olahraga.",
    "variants": [
      { "id": "206-DGray-M", "color": "Dark Grey", "size": "M", "stock": 14, "image": "https://images.pexels.com/photos/4066030/pexels-photo-4066030.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
      { "id": "206-DGray-L", "color": "Dark Grey", "size": "L", "stock": 12, "image": "https://images.pexels.com/photos/4066030/pexels-photo-4066030.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
      { "id": "206-Black-S", "color": "Hitam", "size": "S", "stock": 18, "image": "https://images.pexels.com/photos/6311652/pexels-photo-6311652.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" }
    ], "addons": [], "condimentGroups": []
  },
  {
    "id": 207,
    "name": "Topi Baseball",
    "brand": "Urban Threads / Aksesoris",
    "basePrice": 120000,
    "category": "Fashion / Aksesoris",
    "description": "Topi baseball katun dengan logo bordir minimalis.",
    "variants": [
      { "id": "207-Black", "color": "Hitam", "stock": 25, "image": "https://images.pexels.com/photos/1878821/pexels-photo-1878821.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
      { "id": "207-White", "color": "Putih", "stock": 22, "image": "https://images.pexels.com/photos/2083431/pexels-photo-2083431.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
      { "id": "207-Khaki", "color": "Khaki", "stock": 18, "image": "https://images.pexels.com/photos/2528695/pexels-photo-2528695.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" }
    ], "addons": [], "condimentGroups": []
  },

  // --- Kategori Elektronik ---
  {
    "id": 106,
    "name": "Galaxy Ultra",
    "brand": "Quantum Tech / Mobile",
    "basePrice": 22000000,
    "category": "Elektronik / Smartphone",
    "isBestSeller": true,
    "description": "Flagship terbaru dengan kamera revolusioner dan performa AI.",
    "variants": [
      { "id": "106-Black-256", "color": "Phantom Black", "storage": "256GB", "stock": 15, "image": "https://images.pexels.com/photos/214487/pexels-photo-214487.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
      { "id": "106-Titanium-512", "color": "Titanium Gray", "storage": "512GB", "stock": 10, "image": "https://images.pexels.com/photos/1092644/pexels-photo-1092644.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
      { "id": "106-Violet-256", "color": "Violet Crush", "storage": "256GB", "stock": 8, "image": "https://images.pexels.com/photos/788946/pexels-photo-788946.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" }
    ], "addons": [ { "id": "addon-106-1", "name": "Screen Protector", "price": 150000 }, { "id": "addon-106-2", "name": "Extra Warranty 1 Year", "price": 1000000 } ], "condimentGroups": []
  },
  {
    "id": 107,
    "name": "ProBook X4",
    "brand": "Quantum Tech / Komputer",
    "basePrice": 35000000,
    "category": "Elektronik / Laptop",
    "description": "Kekuatan chip X4 Pro untuk para profesional kreatif.",
    "variants": [ { "id": "107-Gray-16", "color": "Space Gray", "memory": "16GB RAM", "stock": 8, "image": "https://images.pexels.com/photos/434346/pexels-photo-434346.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" } ], "addons": [], "condimentGroups": []
  },
  {
    "id": 112,
    "name": "WH-Pro Noise Cancelling",
    "brand": "Quantum Tech / Audio",
    "basePrice": 5500000,
    "category": "Elektronik / Audio",
    "isBestSeller": true,
    "description": "Headphone dengan noise-cancelling terbaik di kelasnya.",
    "variants": [ { "id": "112-default", "stock": 18, "image": "https://images.pexels.com/photos/1042143/pexels-photo-1042143.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" } ], "addons": [], "condimentGroups": []
  },
  {
    "id": 116,
    "name": "Gaming Mouse Pro",
    "brand": "Quantum Tech / Aksesoris",
    "basePrice": 950000,
    "category": "Elektronik / Aksesoris",
    "description": "Mouse gaming wireless dengan sensor presisi tinggi.",
    "variants": [ { "id": "116-default", "stock": 25, "image": "https://images.pexels.com/photos/2115256/pexels-photo-2115256.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" } ], "addons": [], "condimentGroups": []
  },
   {
    "id": 4,
    "name": "Smartwatch Pro X",
    "brand": "Quantum Tech / Wearable",
    "basePrice": 4200000,
    "category": "Elektronik / Wearable",
    "description": "Smartwatch dengan fitur pelacak kesehatan, GPS, dan notifikasi pintar.",
    "variants": [
      { "id": "4-Black", "color": "Midnight Black", "stock": 25, "image": "https://images.pexels.com/photos/437038/pexels-photo-437038.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
      { "id": "4-Silver", "color": "Starlight Silver", "stock": 18, "image": "https://images.pexels.com/photos/2861929/pexels-photo-2861929.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" }
    ],
    "addons": [
      { "id": "addon-4-1", "name": "Strap Kulit Asli", "price": 250000 },
      { "id": "addon-4-2", "name": "Garansi 1 Tahun", "price": 400000 }
    ], "condimentGroups": []
  },
  {
    "id": 8,
    "name": "True Wireless Earbuds",
    "brand": "Quantum Tech / Audio",
    "basePrice": 1800000,
    "category": "Elektronik / Audio",
    "isBestSeller": false,
    "description": "Earbuds nirkabel dengan suara jernih dan baterai tahan lama.",
    "variants": [
      { "id": "8-White", "color": "Putih", "stock": 22, "image": "https://images.pexels.com/photos/3780681/pexels-photo-3780681.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
      { "id": "8-Black", "color": "Hitam", "stock": 20, "image": "https://images.pexels.com/photos/7915423/pexels-photo-7915423.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" }
    ],
    "addons": [ { "id": "addon-8-1", "name": "Case Pelindung Silikon", "price": 80000 } ], "condimentGroups": []
  },
  {
    "id": 12,
    "name": "Power Bank 20000mAh",
    "brand": "Quantum Tech / Aksesoris",
    "basePrice": 450000,
    "category": "Elektronik / Aksesoris",
    "description": "Power bank kapasitas besar dengan pengisian super cepat.",
    "variants": [
      { "id": "12-Black", "color": "Hitam", "stock": 30, "image": "https://images.pexels.com/photos/1038935/pexels-photo-1038935.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" }
    ],
    "addons": [ { "id": "addon-12-1", "name": "Kabel Braided USB-C", "price": 75000 } ], "condimentGroups": []
  },
  {
    "id": 208,
    "name": "Keyboard Mekanikal TKL",
    "brand": "Quantum Tech / Aksesoris",
    "basePrice": 1200000,
    "category": "Elektronik / Aksesoris",
    "description": "Keyboard Tenkeyless dengan switch Brown dan RGB per-tombol.",
    "variants": [ { "id": "208-default", "stock": 28, "image": "https://images.pexels.com/photos/1772123/pexels-photo-1772123.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" } ],
    "addons": [], "condimentGroups": []
  },
  {
    "id": 209,
    "name": "Tablet Pro 11-inch",
    "brand": "Quantum Tech / Mobile",
    "basePrice": 9500000,
    "category": "Elektronik / Tablet",
    "description": "Tablet serbaguna untuk produktivitas dan hiburan.",
    "variants": [
      { "id": "209-128", "storage": "128GB", "stock": 15, "image": "https://images.pexels.com/photos/1334597/pexels-photo-1334597.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
      { "id": "209-256", "storage": "256GB", "stock": 10, "image": "https://images.pexels.com/photos/1334597/pexels-photo-1334597.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" }
    ],
    "addons": [
      { "id": "addon-209-1", "name": "Smart Keyboard", "price": 1200000 },
      { "id": "addon-209-2", "name": "Pencil Gen 2", "price": 950000 }
    ], "condimentGroups": []
  },
  
  // --- Kategori Rumah Tangga --- (Contoh kategori baru)
  {
    "id": 210,
    "name": "Lilin Aromaterapi",
    "brand": "Serenity Home",
    "basePrice": 150000,
    "category": "Rumah Tangga / Dekorasi",
    "description": "Lilin dari soy wax dengan pilihan aroma yang menenangkan.",
    "variants": [
      { "id": "210-lavender", "aroma": "Lavender", "stock": 30, "image": "https://images.pexels.com/photos/4056468/pexels-photo-4056468.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
      { "id": "210-sandalwood", "aroma": "Sandalwood", "stock": 25, "image": "https://images.pexels.com/photos/7195438/pexels-photo-7195438.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
      { "id": "210-vanilla", "aroma": "Vanilla", "stock": 35, "image": "https://images.pexels.com/photos/4202892/pexels-photo-4202892.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" }
    ], "addons": [], "condimentGroups": []
  },
  {
    "id": 211,
    "name": "Handuk Mandi Premium",
    "brand": "Serenity Home",
    "basePrice": 220000,
    "category": "Rumah Tangga / Kamar Mandi",
    "description": "Handuk katun Mesir yang sangat lembut dan menyerap air.",
    "variants": [
      { "id": "211-white", "color": "Putih", "stock": 40, "image": "https://images.pexels.com/photos/2249962/pexels-photo-2249962.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
      { "id": "211-grey", "color": "Abu-abu", "stock": 30, "image": "https://images.pexels.com/photos/414430/pexels-photo-414430.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" }
    ], "addons": [], "condimentGroups": []
  },
  {
    "id": 212,
    "name": "Biji Kopi Arabika",
    "brand": "Coffee Beans Co.",
    "basePrice": 120000,
    "category": "Bahan Pokok / Kopi",
    "description": "250g biji kopi Arabika single origin dari Gayo.",
    "variants": [ { "id": "212-gayo", "stock": 50, "image": "https://images.pexels.com/photos/302899/pexels-photo-302899.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" } ],
    "addons": [],
    "condimentGroups": [
      { "id": "condiment-212-1", "title": "Pilihan Giling", "type": "radio", "isRequired": true, "options": [
          { "name": "Biji Utuh", "price": 0 },
          { "name": "Giling Kasar (French Press)", "price": 5000 },
          { "name": "Giling Sedang (V60)", "price": 5000 },
          { "name": "Giling Halus (Espresso)", "price": 5000 }
      ] }
    ]
  },
  {
    "id": 213,
    "name": "Madu Hutan Murni",
    "brand": "Natures Harvest",
    "basePrice": 95000,
    "category": "Bahan Pokok / Pemanis",
    "description": "500ml madu hutan murni dari peternakan lokal.",
    "variants": [ { "id": "213-default", "stock": 45, "image": "https://images.pexels.com/photos/265947/pexels-photo-265947.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" } ], "addons": [], "condimentGroups": []
  },
  {
    "id": 214,
    "name": "Granola & Berries",
    "brand": "Natures Harvest",
    "basePrice": 75000,
    "category": "Bahan Pokok / Sereal",
    "description": "Granola panggang dengan campuran buah beri kering.",
    "variants": [ { "id": "214-default", "stock": 40, "image": "https://images.pexels.com/photos/1484516/pexels-photo-1484516.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" } ], "addons": [], "condimentGroups": []
  },
  {
    "id": 215,
    "name": "Notebook Jurnal A5",
    "brand": "Quantum Tech / Aksesoris",
    "basePrice": 85000,
    "category": "Alat Tulis",
    "description": "Buku catatan A5 dengan sampul kulit sintetis dan kertas dotted.",
    "variants": [
      { "id": "215-black", "color": "Hitam", "stock": 33, "image": "https://images.pexels.com/photos/4246120/pexels-photo-4246120.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
      { "id": "215-brown", "color": "Coklat", "stock": 28, "image": "https://images.pexels.com/photos/357573/pexels-photo-357573.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" }
    ], "addons": [], "condimentGroups": []
  },
  {
    "id": 216,
    "name": "Tanaman Hias Monstera",
    "brand": "Serenity Home",
    "basePrice": 180000,
    "category": "Rumah Tangga / Tanaman",
    "description": "Tanaman Monstera Deliciosa hidup dalam pot.",
    "variants": [ { "id": "216-default", "stock": 15, "image": "https://images.pexels.com/photos/2257242/pexels-photo-2257242.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" } ],
    "addons": [{ "id": "addon-216-1", "name": "Pot Keramik Estetik", "price": 50000 }], "condimentGroups": []
  },
  {
    "id": 217,
    "name": "Roti Gandum Utuh",
    "brand": "Koki Hebat / Roti",
    "basePrice": 25000,
    "category": "Makanan / Roti",
    "description": "Roti tawar sehat dari gandum utuh tanpa pengawet.",
    "variants": [ { "id": "217-default", "stock": 30, "image": "https://images.pexels.com/photos/209206/pexels-photo-209206.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" } ], "addons": [], "condimentGroups": []
  },
  {
    "id": 218,
    "name": "Teh Melati",
    "brand": "Fresh Brews / Teh",
    "basePrice": 45000,
    "category": "Minuman / Teh",
    "description": "Teh hijau dengan aroma bunga melati alami (50g).",
    "variants": [ { "id": "218-default", "stock": 40, "image": "https://images.pexels.com/photos/904349/pexels-photo-904349.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" } ], "addons": [], "condimentGroups": []
  },
  {
    "id": 219,
    "name": "Tas Ransel Laptop",
    "brand": "Urban Threads / Aksesoris",
    "basePrice": 480000,
    "category": "Fashion / Aksesoris",
    "description": "Tas ransel anti air dengan kompartemen laptop hingga 15 inci.",
    "variants": [
        { "id": "219-black", "color": "Hitam", "stock": 20, "image": "https://images.pexels.com/photos/1545668/pexels-photo-1545668.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
        { "id": "219-grey", "color": "Abu-abu", "stock": 15, "image": "https://images.pexels.com/photos/2905238/pexels-photo-2905238.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" }
    ], "addons": [], "condimentGroups": []
  },
  {
    "id": 220,
    "name": "Speaker Bluetooth Portabel",
    "brand": "Quantum Tech / Audio",
    "basePrice": 750000,
    "category": "Elektronik / Audio",
    "description": "Speaker portabel tahan air dengan kualitas suara bass mendalam.",
    "variants": [ { "id": "220-default", "stock": 22, "image": "https://images.pexels.com/photos/1279813/pexels-photo-1279813.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" } ], "addons": [], "condimentGroups": []
  },
  

  {
    "id": 300,
    "name": "Gado-Gado Spesial",
    "brand": "Koki Hebat / Masakan Indonesia",
    "basePrice": 32000,
    "category": "Makanan / Salad",
    "description": "Salad sayuran segar dengan saus kacang khas Indonesia, lontong, dan kerupuk.",
    "variants": [ { "id": "300-default", "stock": 40, "image": "https://images.pexels.com/photos/1058277/pexels-photo-1058277.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" } ],
    "addons": [{ "id": "addon-300-1", "name": "Ekstra Lontong", "price": 5000 }],
    "condimentGroups": []
  },
  {
    "id": 301,
    "name": "Jus Mangga Harum Manis",
    "brand": "Fresh Brews / Jus",
    "basePrice": 25000,
    "category": "Minuman / Jus",
    "description": "Jus dari 100% buah mangga harum manis pilihan.",
    "variants": [ { "id": "301-default", "stock": 55, "image": "https://images.pexels.com/photos/5946723/pexels-photo-5946723.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" } ],
    "addons": [],
    "condimentGroups": []
  },
  {
    "id": 302,
    "name": "Kacamata Aviator Klasik",
    "brand": "Urban Threads / Aksesoris",
    "basePrice": 280000,
    "category": "Fashion / Aksesoris",
    "description": "Kacamata hitam model aviator dengan frame metal dan lensa UV protection.",
    "variants": [ { "id": "302-default", "stock": 25, "image": "https://images.pexels.com/photos/70785/sunglasses-glasses-fashion-eye-glasses-70785.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" } ],
    "addons": [],
    "condimentGroups": []
  },
  {
    "id": 303,
    "name": "Monitor Gaming 27 inch 144Hz",
    "brand": "Quantum Tech / Komputer",
    "basePrice": 3800000,
    "category": "Elektronik / Komputer",
    "description": "Monitor gaming IPS 27 inci dengan refresh rate 144Hz dan response time 1ms.",
    "variants": [ { "id": "303-default", "stock": 15, "image": "https://images.pexels.com/photos/777001/pexels-photo-777001.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" } ],
    "addons": [],
    "condimentGroups": []
  },
  {
    "id": 304,
    "name": "Sate Ayam Madura",
    "brand": "Koki Hebat / Masakan Indonesia",
    "basePrice": 40000,
    "category": "Makanan / Ayam",
    "description": "10 tusuk sate ayam dengan bumbu kacang khas Madura dan lontong.",
    "variants": [ { "id": "304-default", "stock": 35, "image": "https://images.pexels.com/photos/5713437/pexels-photo-5713437.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" } ],
    "addons": [{ "id": "addon-304-1", "name": "Ekstra Bawang Goreng", "price": 2000 }],
    "condimentGroups": []
  },
  {
    "id": 305,
    "name": "Thai Tea Original",
    "brand": "Fresh Brews / Teh",
    "basePrice": 22000,
    "category": "Minuman / Teh",
    "description": "Teh susu khas Thailand dengan rasa otentik yang menyegarkan.",
    "variants": [ { "id": "305-default", "stock": 60, "image": "https://images.pexels.com/photos/1579739/pexels-photo-1579739.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" } ],
    "addons": [],
    "condimentGroups": []
  },
  {
    "id": 306,
    "name": "Ikat Pinggang Kulit Asli",
    "brand": "Urban Threads / Aksesoris",
    "basePrice": 350000,
    "category": "Fashion / Aksesoris",
    "description": "Ikat pinggang dari 100% kulit sapi asli dengan gesper metal solid.",
    "variants": [ { "id": "306-black", "color": "Hitam", "stock": 30, "image": "https://images.pexels.com/photos/984539/pexels-photo-984539.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" } ],
    "addons": [],
    "condimentGroups": []
  },
  {
    "id": 307,
    "name": "Webcam HD 1080p",
    "brand": "Quantum Tech / Aksesoris",
    "basePrice": 650000,
    "category": "Elektronik / Aksesoris",
    "description": "Webcam Full HD dengan auto-focus dan built-in microphone.",
    "variants": [ { "id": "307-default", "stock": 40, "image": "https://images.pexels.com/photos/7238759/pexels-photo-7238759.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" } ],
    "addons": [],
    "condimentGroups": []
  },
  {
    "id": 308,
    "name": "Croissant Coklat",
    "brand": "Koki Hebat / Roti",
    "basePrice": 25000,
    "category": "Makanan / Roti",
    "description": "Croissant renyah dengan isian coklat premium yang meleleh.",
    "variants": [ { "id": "308-default", "stock": 50, "image": "https://images.pexels.com/photos/267951/pexels-photo-267951.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" } ],
    "addons": [],
    "condimentGroups": []
  },
  {
    "id": 309,
    "name": "Celana Jeans Sobek",
    "brand": "Urban Threads / Casual",
    "basePrice": 420000,
    "category": "Fashion / Bawahan",
    "description": "Celana jeans model ripped dengan potongan slim-fit yang stylish.",
    "variants": [ { "id": "309-blue-32", "color": "Biru Muda", "size": "32", "stock": 18, "image": "https://images.pexels.com/photos/1598505/pexels-photo-1598505.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" } ],
    "addons": [],
    "condimentGroups": []
  },
  {
    "id": 310,
    "name": "Kopi Americano",
    "brand": "Fresh Brews / Kopi",
    "basePrice": 28000,
    "category": "Minuman / Kopi",
    "description": "Espresso shot yang diencerkan dengan air panas, disajikan panas atau dingin.",
    "variants": [
        { "id": "310-Hot", "temp": "Panas", "stock": 30, "image": "https://images.pexels.com/photos/373639/pexels-photo-373639.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
        { "id": "310-Cold", "temp": "Dingin", "stock": 35, "image": "https://images.pexels.com/photos/373639/pexels-photo-373639.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" }
    ],
    "addons": [],
    "condimentGroups": []
  },
  {
    "id": 311,
    "name": "Kipas Angin Meja USB",
    "brand": "Serenity Home",
    "basePrice": 125000,
    "category": "Rumah Tangga / Elektronik Kecil",
    "description": "Kipas angin portabel yang ditenagai oleh USB, senyap dan efisien.",
    "variants": [ { "id": "311-default", "stock": 45, "image": "https://images.pexels.com/photos/172292/pexels-photo-172292.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" } ],
    "addons": [],
    "condimentGroups": []
  },
  {
    "id": 312,
    "name": "Lasagna Bolognese",
    "brand": "Koki Hebat / Masakan Barat",
    "basePrice": 95000,
    "category": "Makanan / Pasta",
    "description": "Lapisan pasta dengan saus daging bolognese dan keju bechamel.",
    "variants": [ { "id": "312-default", "stock": 22, "image": "https://images.pexels.com/photos/5863486/pexels-photo-5863486.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" } ],
    "addons": [],
    "condimentGroups": []
  },
  {
    "id": 313,
    "name": "Dompet Kulit Pria",
    "brand": "Urban Threads / Aksesoris",
    "basePrice": 290000,
    "category": "Fashion / Aksesoris",
    "description": "Dompet lipat pria dari kulit asli dengan banyak slot kartu.",
    "variants": [ { "id": "313-brown", "color": "Coklat Tua", "stock": 38, "image": "https://images.pexels.com/photos/298862/pexels-photo-298862.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" } ],
    "addons": [],
    "condimentGroups": []
  },
  {
    "id": 314,
    "name": "Router Wi-Fi 6",
    "brand": "Quantum Tech / Jaringan",
    "basePrice": 1350000,
    "category": "Elektronik / Jaringan",
    "description": "Router dual-band dengan teknologi Wi-Fi 6 untuk kecepatan internet maksimal.",
    "variants": [ { "id": "314-default", "stock": 18, "image": "https://images.pexels.com/photos/392018/pexels-photo-392018.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" } ],
    "addons": [],
    "condimentGroups": []
  },
  {
    "id": 315,
    "name": "Teh Bunga Telang",
    "brand": "Fresh Brews / Teh",
    "basePrice": 23000,
    "category": "Minuman / Teh",
    "description": "Teh herbal dari bunga telang yang bisa berubah warna dengan lemon.",
    "variants": [ { "id": "315-default", "stock": 40, "image": "https://images.pexels.com/photos/8995393/pexels-photo-8995393.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" } ],
    "addons": [],
    "condimentGroups": []
  },
  {
    "id": 316,
    "name": "Minyak Zaitun Extra Virgin",
    "brand": "Natures Harvest",
    "basePrice": 85000,
    "category": "Bahan Pokok / Minyak",
    "description": "250ml minyak zaitun murni untuk salad dan masakan sehat.",
    "variants": [ { "id": "316-default", "stock": 50, "image": "https://images.pexels.com/photos/668300/pexels-photo-668300.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" } ],
    "addons": [],
    "condimentGroups": []
  },
  {
    "id": 317,
    "name": "Tumbler Kopi Stainless Steel",
    "brand": "Serenity Home",
    "basePrice": 180000,
    "category": "Rumah Tangga / Peralatan Minum",
    "description": "Tumbler 500ml yang dapat menjaga suhu minuman panas atau dingin.",
    "variants": [ { "id": "317-black", "color": "Hitam", "stock": 35, "image": "https://images.pexels.com/photos/324028/pexels-photo-324028.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" } ],
    "addons": [],
    "condimentGroups": []
  },
  {
    "id": 318,
    "name": "Sandal Slide",
    "brand": "Urban Threads / Active",
    "basePrice": 150000,
    "category": "Fashion / Sepatu",
    "description": "Sandal slide yang empuk dan nyaman untuk bersantai.",
    "variants": [
        { "id": "318-black-41", "color": "Hitam", "size": "41", "stock": 25, "image": "https://images.pexels.com/photos/167706/pexels-photo-167706.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" },
        { "id": "318-white-42", "color": "Putih", "size": "42", "stock": 22, "image": "https://images.pexels.com/photos/167706/pexels-photo-167706.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" }
    ],
    "addons": [],
    "condimentGroups": []
  },
  {
    "id": 319,
    "name": "Mie Ayam Jamur",
    "brand": "Koki Hebat / Masakan Asia",
    "basePrice": 30000,
    "category": "Makanan / Mie",
    "description": "Mie ayam klasik dengan topping ayam kecap dan jamur.",
    "variants": [ { "id": "319-default", "stock": 40, "image": "https://images.pexels.com/photos/2347311/pexels-photo-2347311.jpeg?auto=compress&cs=tinysrgb&w=500&h=500" } ],
    "addons": [{ "id": "addon-319-1", "name": "Ekstra Pangsit", "price": 5000 }],
    "condimentGroups": []
  },


  {
    "id": 350,
    "basePrice": 51100,
    "category": "Minuman",
    "isBestSeller": false,
    "variants": [
      {
        "id": "350-default",
        "stock": 13,
        "image": "https://images.unsplash.com/photo-1551030172-1353e659b52a?w=500"
      }
    ],
    "addons": [],
    "condimentGroups": [],
    "brand": "Fresh Brews / Teh",
    "name": "Kopi Mantap",
    "description": "Minuman segar yang dibuat dari bahan-bahan berkualitas untuk mencerahkan harimu."
  },
  {
    "id": 351,
    "basePrice": 423700,
    "category": "Minuman",
    "isBestSeller": false,
    "variants": [
      {
        "id": "351-Hot",
        "temp": "Panas",
        "stock": 25,
        "image": "https://images.unsplash.com/photo-1517256064218-b4f36b544367?w=500"
      },
      {
        "id": "351-Cold",
        "temp": "Dingin",
        "stock": 24,
        "image": "https://images.unsplash.com/photo-1551030172-1353e659b52a?w=500"
      }
    ],
    "addons": [
      {
        "id": "addon-351-1",
        "name": "Ekstra Gula",
        "price": 1000
      }
    ],
    "condimentGroups": [],
    "brand": "Fresh Brews / Jus",
    "name": "Es Spesial",
    "description": "Minuman segar yang dibuat dari bahan-bahan berkualitas untuk mencerahkan harimu."
  },
  {
    "id": 352,
    "basePrice": 446400,
    "category": "Makanan",
    "isBestSeller": true,
    "variants": [
      {
        "id": "352-default",
        "stock": 25,
        "image": "https://images.unsplash.com/photo-1546069901-ba9599a7e63c?w=500"
      }
    ],
    "addons": [],
    "condimentGroups": [
      {
        "id": "condiment-352-1",
        "title": "Pilih Tingkat Pedas",
        "type": "radio",
        "isRequired": true,
        "options": [
          {
            "name": "Tidak Pedas",
            "price": 0
          },
          {
            "name": "Sedang",
            "price": 0
          },
          {
            "name": "Sangat Pedas",
            "price": 1000
          }
        ]
      },
      {
        "id": "condiment-352-2",
        "title": "Topping Tambahan",
        "type": "checkbox",
        "isRequired": false,
        "options": [
          {
            "name": "Bawang Goreng",
            "price": 1000
          },
          {
            "name": "Kerupuk",
            "price": 2000
          }
        ]
      }
    ],
    "brand": "Koki Hebat / Masakan Barat",
    "name": "Nasi Spesial",
    "description": "Sebuah hidangan istimewa yang dibuat dengan bahan-bahan pilihan, menghasilkan cita rasa yang tak terlupakan."
  },
  {
    "id": 353,
    "basePrice": 107700,
    "category": "Makanan",
    "isBestSeller": false,
    "variants": [
      {
        "id": "353-default",
        "stock": 26,
        "image": "https://images.unsplash.com/photo-1546069901-ba9599a7e63c?w=500"
      }
    ],
    "addons": [],
    "condimentGroups": [
      {
        "id": "condiment-353-1",
        "title": "Pilih Tingkat Pedas",
        "type": "radio",
        "isRequired": true,
        "options": [
          {
            "name": "Tidak Pedas",
            "price": 0
          },
          {
            "name": "Sedang",
            "price": 0
          },
          {
            "name": "Sangat Pedas",
            "price": 1000
          }
        ]
      },
      {
        "id": "condiment-353-2",
        "title": "Topping Tambahan",
        "type": "checkbox",
        "isRequired": false,
        "options": [
          {
            "name": "Bawang Goreng",
            "price": 1000
          },
          {
            "name": "Kerupuk",
            "price": 2000
          }
        ]
      }
    ],
    "brand": "Koki Hebat / Masakan Asia",
    "name": "Sop Juara",
    "description": "Sebuah hidangan istimewa yang dibuat dengan bahan-bahan pilihan, menghasilkan cita rasa yang tak terlupakan."
  },
  {
    "id": 354,
    "basePrice": 250200,
    "category": "Elektronik",
    "isBestSeller": true,
    "variants": [
      {
        "id": "354-default",
        "stock": 11,
        "image": "https://images.unsplash.com/photo-1525547719571-a2d4ac8945e2?w=500"
      }
    ],
    "addons": [],
    "condimentGroups": [],
    "brand": "Quantum Tech / Audio",
    "name": "Audio Device",
    "description": "Perangkat elektronik canggih untuk menunjang produktivitas dan gaya hidup modern Anda."
  },
  {
    "id": 355,
    "basePrice": 339300,
    "category": "Makanan",
    "isBestSeller": false,
    "variants": [
      {
        "id": "355-default",
        "stock": 44,
        "image": "https://images.unsplash.com/photo-1546069901-ba9599a7e63c?w=500"
      }
    ],
    "addons": [],
    "condimentGroups": [
      {
        "id": "condiment-355-1",
        "title": "Pilih Tingkat Pedas",
        "type": "radio",
        "isRequired": true,
        "options": [
          {
            "name": "Tidak Pedas",
            "price": 0
          },
          {
            "name": "Sedang",
            "price": 0
          },
          {
            "name": "Sangat Pedas",
            "price": 1000
          }
        ]
      },
      {
        "id": "condiment-355-2",
        "title": "Topping Tambahan",
        "type": "checkbox",
        "isRequired": false,
        "options": [
          {
            "name": "Bawang Goreng",
            "price": 1000
          },
          {
            "name": "Kerupuk",
            "price": 2000
          }
        ]
      }
    ],
    "brand": "Koki Hebat / Masakan Asia",
    "name": "Sop Juara",
    "description": "Sebuah hidangan istimewa yang dibuat dengan bahan-bahan pilihan, menghasilkan cita rasa yang tak terlupakan."
  },
  {
    "id": 356,
    "basePrice": 334600,
    "category": "Makanan",
    "isBestSeller": false,
    "variants": [
      {
        "id": "356-default",
        "stock": 46,
        "image": "https://images.unsplash.com/photo-1546069901-ba9599a7e63c?w=500"
      }
    ],
    "addons": [],
    "condimentGroups": [
      {
        "id": "condiment-356-1",
        "title": "Pilih Tingkat Pedas",
        "type": "radio",
        "isRequired": true,
        "options": [
          {
            "name": "Tidak Pedas",
            "price": 0
          },
          {
            "name": "Sedang",
            "price": 0
          },
          {
            "name": "Sangat Pedas",
            "price": 1000
          }
        ]
      },
      {
        "id": "condiment-356-2",
        "title": "Topping Tambahan",
        "type": "checkbox",
        "isRequired": false,
        "options": [
          {
            "name": "Bawang Goreng",
            "price": 1000
          },
          {
            "name": "Kerupuk",
            "price": 2000
          }
        ]
      }
    ],
    "brand": "Koki Hebat / Masakan Asia",
    "name": "Nasi Spesial",
    "description": "Sebuah hidangan istimewa yang dibuat dengan bahan-bahan pilihan, menghasilkan cita rasa yang tak terlupakan."
  },
  {
    "id": 357,
    "basePrice": 192700,
    "category": "Minuman",
    "isBestSeller": false,
    "variants": [
      {
        "id": "357-default",
        "stock": 21,
        "image": "https://images.unsplash.com/photo-1551030172-1353e659b52a?w=500"
      }
    ],
    "addons": [],
    "condimentGroups": [],
    "brand": "Fresh Brews / Kopi",
    "name": "Kopi Mantap",
    "description": "Minuman segar yang dibuat dari bahan-bahan berkualitas untuk mencerahkan harimu."
  },
  {
    "id": 358,
    "basePrice": 359400,
    "category": "Fashion",
    "isBestSeller": false,
    "variants": [
      {
        "id": "358-Hitam-S",
        "color": "Hitam",
        "size": "S",
        "stock": 29,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "358-Hitam-L",
        "color": "Hitam",
        "size": "L",
        "stock": 1,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "358-Hitam-M",
        "color": "Hitam",
        "size": "M",
        "stock": 26,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "358-Hitam-XL",
        "color": "Hitam",
        "size": "XL",
        "stock": 15,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "358-Hijau-XL",
        "color": "Hijau",
        "size": "XL",
        "stock": 11,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "358-Hijau-L",
        "color": "Hijau",
        "size": "L",
        "stock": 22,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "358-Hijau-S",
        "color": "Hijau",
        "size": "S",
        "stock": 1,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "358-Hijau-M",
        "color": "Hijau",
        "size": "M",
        "stock": 13,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "358-Biru-L",
        "color": "Biru",
        "size": "L",
        "stock": 17,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "358-Biru-XL",
        "color": "Biru",
        "size": "XL",
        "stock": 10,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "358-Biru-S",
        "color": "Biru",
        "size": "S",
        "stock": 8,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "358-Biru-M",
        "color": "Biru",
        "size": "M",
        "stock": 4,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      }
    ],
    "addons": [],
    "condimentGroups": [],
    "brand": "Urban Threads / Casual",
    "name": "Kaos Modern",
    "description": "Tampil gaya dan percaya diri dengan koleksi fashion terbaru kami yang berkualitas tinggi."
  },
  {
    "id": 359,
    "basePrice": 413800,
    "category": "Elektronik",
    "isBestSeller": false,
    "variants": [
      {
        "id": "359-default",
        "stock": 19,
        "image": "https://images.unsplash.com/photo-1525547719571-a2d4ac8945e2?w=500"
      }
    ],
    "addons": [],
    "condimentGroups": [],
    "brand": "Quantum Tech / Mobile",
    "name": "Data Hub",
    "description": "Perangkat elektronik canggih untuk menunjang produktivitas dan gaya hidup modern Anda."
  },
  {
    "id": 360,
    "basePrice": 246500,
    "category": "Minuman",
    "isBestSeller": false,
    "variants": [
      {
        "id": "360-Hot",
        "temp": "Panas",
        "stock": 46,
        "image": "https://images.unsplash.com/photo-1517256064218-b4f36b544367?w=500"
      },
      {
        "id": "360-Cold",
        "temp": "Dingin",
        "stock": 40,
        "image": "https://images.unsplash.com/photo-1551030172-1353e659b52a?w=500"
      }
    ],
    "addons": [
      {
        "id": "addon-360-1",
        "name": "Ekstra Gula",
        "price": 1000
      }
    ],
    "condimentGroups": [],
    "brand": "Fresh Brews / Jus",
    "name": "Kopi Segar",
    "description": "Minuman segar yang dibuat dari bahan-bahan berkualitas untuk mencerahkan harimu."
  },
  {
    "id": 361,
    "basePrice": 166700,
    "category": "Elektronik",
    "isBestSeller": false,
    "variants": [
      {
        "id": "361-default",
        "stock": 17,
        "image": "https://images.unsplash.com/photo-1525547719571-a2d4ac8945e2?w=500"
      }
    ],
    "addons": [],
    "condimentGroups": [],
    "brand": "Quantum Tech / Mobile",
    "name": "Smart Hub",
    "description": "Perangkat elektronik canggih untuk menunjang produktivitas dan gaya hidup modern Anda."
  },
  {
    "id": 362,
    "basePrice": 376700,
    "category": "Makanan",
    "isBestSeller": true,
    "variants": [
      {
        "id": "362-default",
        "stock": 26,
        "image": "https://images.unsplash.com/photo-1546069901-ba9599a7e63c?w=500"
      }
    ],
    "addons": [],
    "condimentGroups": [
      {
        "id": "condiment-362-1",
        "title": "Pilih Tingkat Pedas",
        "type": "radio",
        "isRequired": true,
        "options": [
          {
            "name": "Tidak Pedas",
            "price": 0
          },
          {
            "name": "Sedang",
            "price": 0
          },
          {
            "name": "Sangat Pedas",
            "price": 1000
          }
        ]
      },
      {
        "id": "condiment-362-2",
        "title": "Topping Tambahan",
        "type": "checkbox",
        "isRequired": false,
        "options": [
          {
            "name": "Bawang Goreng",
            "price": 1000
          },
          {
            "name": "Kerupuk",
            "price": 2000
          }
        ]
      }
    ],
    "brand": "Koki Hebat / Roti",
    "name": "Nasi Nikmat",
    "description": "Sebuah hidangan istimewa yang dibuat dengan bahan-bahan pilihan, menghasilkan cita rasa yang tak terlupakan."
  },
  {
    "id": 363,
    "basePrice": 485600,
    "category": "Makanan",
    "isBestSeller": true,
    "variants": [
      {
        "id": "363-default",
        "stock": 37,
        "image": "https://images.unsplash.com/photo-1546069901-ba9599a7e63c?w=500"
      }
    ],
    "addons": [],
    "condimentGroups": [
      {
        "id": "condiment-363-1",
        "title": "Pilih Tingkat Pedas",
        "type": "radio",
        "isRequired": true,
        "options": [
          {
            "name": "Tidak Pedas",
            "price": 0
          },
          {
            "name": "Sedang",
            "price": 0
          },
          {
            "name": "Sangat Pedas",
            "price": 1000
          }
        ]
      },
      {
        "id": "condiment-363-2",
        "title": "Topping Tambahan",
        "type": "checkbox",
        "isRequired": false,
        "options": [
          {
            "name": "Bawang Goreng",
            "price": 1000
          },
          {
            "name": "Kerupuk",
            "price": 2000
          }
        ]
      }
    ],
    "brand": "Koki Hebat / Masakan Barat",
    "name": "Mie Juara",
    "description": "Sebuah hidangan istimewa yang dibuat dengan bahan-bahan pilihan, menghasilkan cita rasa yang tak terlupakan."
  },
  {
    "id": 364,
    "basePrice": 437000,
    "category": "Makanan",
    "isBestSeller": true,
    "variants": [
      {
        "id": "364-default",
        "stock": 11,
        "image": "https://images.unsplash.com/photo-1546069901-ba9599a7e63c?w=500"
      }
    ],
    "addons": [],
    "condimentGroups": [
      {
        "id": "condiment-364-1",
        "title": "Pilih Tingkat Pedas",
        "type": "radio",
        "isRequired": true,
        "options": [
          {
            "name": "Tidak Pedas",
            "price": 0
          },
          {
            "name": "Sedang",
            "price": 0
          },
          {
            "name": "Sangat Pedas",
            "price": 1000
          }
        ]
      },
      {
        "id": "condiment-364-2",
        "title": "Topping Tambahan",
        "type": "checkbox",
        "isRequired": false,
        "options": [
          {
            "name": "Bawang Goreng",
            "price": 1000
          },
          {
            "name": "Kerupuk",
            "price": 2000
          }
        ]
      }
    ],
    "brand": "Koki Hebat / Masakan Barat",
    "name": "Mie Lezat",
    "description": "Sebuah hidangan istimewa yang dibuat dengan bahan-bahan pilihan, menghasilkan cita rasa yang tak terlupakan."
  },
  {
    "id": 365,
    "basePrice": 66600,
    "category": "Fashion",
    "isBestSeller": true,
    "variants": [
      {
        "id": "365-Biru-S",
        "color": "Biru",
        "size": "S",
        "stock": 0,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "365-Biru-L",
        "color": "Biru",
        "size": "L",
        "stock": 3,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "365-Biru-XL",
        "color": "Biru",
        "size": "XL",
        "stock": 26,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "365-Hijau-S",
        "color": "Hijau",
        "size": "S",
        "stock": 22,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "365-Hijau-L",
        "color": "Hijau",
        "size": "L",
        "stock": 10,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "365-Hijau-M",
        "color": "Hijau",
        "size": "M",
        "stock": 11,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "365-Hijau-XL",
        "color": "Hijau",
        "size": "XL",
        "stock": 11,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      }
    ],
    "addons": [],
    "condimentGroups": [],
    "brand": "Urban Threads / Aksesoris",
    "name": "Celana Eksklusif",
    "description": "Tampil gaya dan percaya diri dengan koleksi fashion terbaru kami yang berkualitas tinggi."
  },
  {
    "id": 366,
    "basePrice": 178800,
    "category": "Elektronik",
    "isBestSeller": false,
    "variants": [
      {
        "id": "366-default",
        "stock": 14,
        "image": "https://images.unsplash.com/photo-1525547719571-a2d4ac8945e2?w=500"
      }
    ],
    "addons": [
      {
        "id": "addon-366-1",
        "name": "Garansi Ekstra 1 Tahun",
        "price": 80000
      },
      {
        "id": "addon-366-2",
        "name": "Casing Pelindung",
        "price": 130000
      }
    ],
    "condimentGroups": [],
    "brand": "Quantum Tech / Aksesoris",
    "name": "Smart System",
    "description": "Perangkat elektronik canggih untuk menunjang produktivitas dan gaya hidup modern Anda."
  },
  {
    "id": 367,
    "basePrice": 319600,
    "category": "Makanan",
    "isBestSeller": false,
    "variants": [
      {
        "id": "367-default",
        "stock": 20,
        "image": "https://images.unsplash.com/photo-1546069901-ba9599a7e63c?w=500"
      }
    ],
    "addons": [],
    "condimentGroups": [
      {
        "id": "condiment-367-1",
        "title": "Pilih Tingkat Pedas",
        "type": "radio",
        "isRequired": true,
        "options": [
          {
            "name": "Tidak Pedas",
            "price": 0
          },
          {
            "name": "Sedang",
            "price": 0
          },
          {
            "name": "Sangat Pedas",
            "price": 1000
          }
        ]
      },
      {
        "id": "condiment-367-2",
        "title": "Topping Tambahan",
        "type": "checkbox",
        "isRequired": false,
        "options": [
          {
            "name": "Bawang Goreng",
            "price": 1000
          },
          {
            "name": "Kerupuk",
            "price": 2000
          }
        ]
      }
    ],
    "brand": "Koki Hebat / Roti",
    "name": "Mie Lezat",
    "description": "Sebuah hidangan istimewa yang dibuat dengan bahan-bahan pilihan, menghasilkan cita rasa yang tak terlupakan."
  },
  {
    "id": 368,
    "basePrice": 457600,
    "category": "Minuman",
    "isBestSeller": false,
    "variants": [
      {
        "id": "368-Hot",
        "temp": "Panas",
        "stock": 44,
        "image": "https://images.unsplash.com/photo-1517256064218-b4f36b544367?w=500"
      },
      {
        "id": "368-Cold",
        "temp": "Dingin",
        "stock": 27,
        "image": "https://images.unsplash.com/photo-1551030172-1353e659b52a?w=500"
      }
    ],
    "addons": [],
    "condimentGroups": [],
    "brand": "Fresh Brews / Kopi",
    "name": "Es Mantap",
    "description": "Minuman segar yang dibuat dari bahan-bahan berkualitas untuk mencerahkan harimu."
  },
  {
    "id": 369,
    "basePrice": 474500,
    "category": "Makanan",
    "isBestSeller": true,
    "variants": [
      {
        "id": "369-default",
        "stock": 12,
        "image": "https://images.unsplash.com/photo-1546069901-ba9599a7e63c?w=500"
      }
    ],
    "addons": [],
    "condimentGroups": [
      {
        "id": "condiment-369-1",
        "title": "Pilih Tingkat Pedas",
        "type": "radio",
        "isRequired": true,
        "options": [
          {
            "name": "Tidak Pedas",
            "price": 0
          },
          {
            "name": "Sedang",
            "price": 0
          },
          {
            "name": "Sangat Pedas",
            "price": 1000
          }
        ]
      },
      {
        "id": "condiment-369-2",
        "title": "Topping Tambahan",
        "type": "checkbox",
        "isRequired": false,
        "options": [
          {
            "name": "Bawang Goreng",
            "price": 1000
          },
          {
            "name": "Kerupuk",
            "price": 2000
          }
        ]
      }
    ],
    "brand": "Koki Hebat / Masakan Barat",
    "name": "Nasi Lezat",
    "description": "Sebuah hidangan istimewa yang dibuat dengan bahan-bahan pilihan, menghasilkan cita rasa yang tak terlupakan."
  },
  {
    "id": 370,
    "basePrice": 372200,
    "category": "Makanan",
    "isBestSeller": true,
    "variants": [
      {
        "id": "370-default",
        "stock": 23,
        "image": "https://images.unsplash.com/photo-1546069901-ba9599a7e63c?w=500"
      }
    ],
    "addons": [],
    "condimentGroups": [
      {
        "id": "condiment-370-1",
        "title": "Pilih Tingkat Pedas",
        "type": "radio",
        "isRequired": true,
        "options": [
          {
            "name": "Tidak Pedas",
            "price": 0
          },
          {
            "name": "Sedang",
            "price": 0
          },
          {
            "name": "Sangat Pedas",
            "price": 1000
          }
        ]
      },
      {
        "id": "condiment-370-2",
        "title": "Topping Tambahan",
        "type": "checkbox",
        "isRequired": false,
        "options": [
          {
            "name": "Bawang Goreng",
            "price": 1000
          },
          {
            "name": "Kerupuk",
            "price": 2000
          }
        ]
      }
    ],
    "brand": "Koki Hebat / Roti",
    "name": "Sate Nikmat",
    "description": "Sebuah hidangan istimewa yang dibuat dengan bahan-bahan pilihan, menghasilkan cita rasa yang tak terlupakan."
  },
  {
    "id": 371,
    "basePrice": 411000,
    "category": "Elektronik",
    "isBestSeller": false,
    "variants": [
      {
        "id": "371-default",
        "stock": 15,
        "image": "https://images.unsplash.com/photo-1525547719571-a2d4ac8945e2?w=500"
      }
    ],
    "addons": [
      {
        "id": "addon-371-1",
        "name": "Garansi Ekstra 1 Tahun",
        "price": 190000
      },
      {
        "id": "addon-371-2",
        "name": "Casing Pelindung",
        "price": 210000
      }
    ],
    "condimentGroups": [],
    "brand": "Quantum Tech / Mobile",
    "name": "Data System",
    "description": "Perangkat elektronik canggih untuk menunjang produktivitas dan gaya hidup modern Anda."
  },
  {
    "id": 372,
    "basePrice": 317500,
    "category": "Elektronik",
    "isBestSeller": true,
    "variants": [
      {
        "id": "372-default",
        "stock": 19,
        "image": "https://images.unsplash.com/photo-1525547719571-a2d4ac8945e2?w=500"
      }
    ],
    "addons": [],
    "condimentGroups": [],
    "brand": "Quantum Tech / Komputer",
    "name": "Audio Hub",
    "description": "Perangkat elektronik canggih untuk menunjang produktivitas dan gaya hidup modern Anda."
  },
  {
    "id": 373,
    "basePrice": 100500,
    "category": "Elektronik",
    "isBestSeller": false,
    "variants": [
      {
        "id": "373-default",
        "stock": 12,
        "image": "https://images.unsplash.com/photo-1525547719571-a2d4ac8945e2?w=500"
      }
    ],
    "addons": [],
    "condimentGroups": [],
    "brand": "Quantum Tech / Wearable",
    "name": "Audio System",
    "description": "Perangkat elektronik canggih untuk menunjang produktivitas dan gaya hidup modern Anda."
  },
  {
    "id": 374,
    "basePrice": 279800,
    "category": "Elektronik",
    "isBestSeller": false,
    "variants": [
      {
        "id": "374-default",
        "stock": 14,
        "image": "https://images.unsplash.com/photo-1525547719571-a2d4ac8945e2?w=500"
      }
    ],
    "addons": [
      {
        "id": "addon-374-1",
        "name": "Garansi Ekstra 1 Tahun",
        "price": 50000
      },
      {
        "id": "addon-374-2",
        "name": "Casing Pelindung",
        "price": 170000
      }
    ],
    "condimentGroups": [],
    "brand": "Quantum Tech / Mobile",
    "name": "Power Hub",
    "description": "Perangkat elektronik canggih untuk menunjang produktivitas dan gaya hidup modern Anda."
  },
  {
    "id": 375,
    "basePrice": 398900,
    "category": "Elektronik",
    "isBestSeller": false,
    "variants": [
      {
        "id": "375-default",
        "stock": 19,
        "image": "https://images.unsplash.com/photo-1525547719571-a2d4ac8945e2?w=500"
      }
    ],
    "addons": [],
    "condimentGroups": [],
    "brand": "Quantum Tech / Mobile",
    "name": "Audio Device",
    "description": "Perangkat elektronik canggih untuk menunjang produktivitas dan gaya hidup modern Anda."
  },
  {
    "id": 376,
    "basePrice": 64400,
    "category": "Makanan",
    "isBestSeller": false,
    "variants": [
      {
        "id": "376-default",
        "stock": 21,
        "image": "https://images.unsplash.com/photo-1546069901-ba9599a7e63c?w=500"
      }
    ],
    "addons": [],
    "condimentGroups": [
      {
        "id": "condiment-376-1",
        "title": "Pilih Tingkat Pedas",
        "type": "radio",
        "isRequired": true,
        "options": [
          {
            "name": "Tidak Pedas",
            "price": 0
          },
          {
            "name": "Sedang",
            "price": 0
          },
          {
            "name": "Sangat Pedas",
            "price": 1000
          }
        ]
      },
      {
        "id": "condiment-376-2",
        "title": "Topping Tambahan",
        "type": "checkbox",
        "isRequired": false,
        "options": [
          {
            "name": "Bawang Goreng",
            "price": 1000
          },
          {
            "name": "Kerupuk",
            "price": 2000
          }
        ]
      }
    ],
    "brand": "Koki Hebat / Masakan Indonesia",
    "name": "Mie Nikmat",
    "description": "Sebuah hidangan istimewa yang dibuat dengan bahan-bahan pilihan, menghasilkan cita rasa yang tak terlupakan."
  },
  {
    "id": 377,
    "basePrice": 228600,
    "category": "Fashion",
    "isBestSeller": false,
    "variants": [
      {
        "id": "377-Biru-XL",
        "color": "Biru",
        "size": "XL",
        "stock": 10,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "377-Biru-S",
        "color": "Biru",
        "size": "S",
        "stock": 15,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "377-Biru-L",
        "color": "Biru",
        "size": "L",
        "stock": 24,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "377-Biru-M",
        "color": "Biru",
        "size": "M",
        "stock": 13,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      }
    ],
    "addons": [],
    "condimentGroups": [],
    "brand": "Urban Threads / Outerwear",
    "name": "Kemeja Eksklusif",
    "description": "Tampil gaya dan percaya diri dengan koleksi fashion terbaru kami yang berkualitas tinggi."
  },
  {
    "id": 378,
    "basePrice": 166300,
    "category": "Fashion",
    "isBestSeller": false,
    "variants": [
      {
        "id": "378-Merah-XL",
        "color": "Merah",
        "size": "XL",
        "stock": 5,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "378-Merah-L",
        "color": "Merah",
        "size": "L",
        "stock": 9,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "378-Merah-M",
        "color": "Merah",
        "size": "M",
        "stock": 11,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "378-Hitam-M",
        "color": "Hitam",
        "size": "M",
        "stock": 17,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "378-Hitam-XL",
        "color": "Hitam",
        "size": "XL",
        "stock": 7,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "378-Biru-XL",
        "color": "Biru",
        "size": "XL",
        "stock": 7,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "378-Biru-M",
        "color": "Biru",
        "size": "M",
        "stock": 30,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "378-Biru-S",
        "color": "Biru",
        "size": "S",
        "stock": 2,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "378-Biru-L",
        "color": "Biru",
        "size": "L",
        "stock": 1,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      }
    ],
    "addons": [],
    "condimentGroups": [],
    "brand": "Urban Threads / Aksesoris",
    "name": "Celana Vintage",
    "description": "Tampil gaya dan percaya diri dengan koleksi fashion terbaru kami yang berkualitas tinggi."
  },
  {
    "id": 379,
    "basePrice": 240700,
    "category": "Makanan",
    "isBestSeller": false,
    "variants": [
      {
        "id": "379-default",
        "stock": 32,
        "image": "https://images.unsplash.com/photo-1546069901-ba9599a7e63c?w=500"
      }
    ],
    "addons": [],
    "condimentGroups": [
      {
        "id": "condiment-379-1",
        "title": "Pilih Tingkat Pedas",
        "type": "radio",
        "isRequired": true,
        "options": [
          {
            "name": "Tidak Pedas",
            "price": 0
          },
          {
            "name": "Sedang",
            "price": 0
          },
          {
            "name": "Sangat Pedas",
            "price": 1000
          }
        ]
      },
      {
        "id": "condiment-379-2",
        "title": "Topping Tambahan",
        "type": "checkbox",
        "isRequired": false,
        "options": [
          {
            "name": "Bawang Goreng",
            "price": 1000
          },
          {
            "name": "Kerupuk",
            "price": 2000
          }
        ]
      }
    ],
    "brand": "Koki Hebat / Masakan Indonesia",
    "name": "Ayam Juara",
    "description": "Sebuah hidangan istimewa yang dibuat dengan bahan-bahan pilihan, menghasilkan cita rasa yang tak terlupakan."
  },
  {
    "id": 380,
    "basePrice": 279500,
    "category": "Makanan",
    "isBestSeller": false,
    "variants": [
      {
        "id": "380-default",
        "stock": 22,
        "image": "https://images.unsplash.com/photo-1546069901-ba9599a7e63c?w=500"
      }
    ],
    "addons": [],
    "condimentGroups": [
      {
        "id": "condiment-380-1",
        "title": "Pilih Tingkat Pedas",
        "type": "radio",
        "isRequired": true,
        "options": [
          {
            "name": "Tidak Pedas",
            "price": 0
          },
          {
            "name": "Sedang",
            "price": 0
          },
          {
            "name": "Sangat Pedas",
            "price": 1000
          }
        ]
      },
      {
        "id": "condiment-380-2",
        "title": "Topping Tambahan",
        "type": "checkbox",
        "isRequired": false,
        "options": [
          {
            "name": "Bawang Goreng",
            "price": 1000
          },
          {
            "name": "Kerupuk",
            "price": 2000
          }
        ]
      }
    ],
    "brand": "Koki Hebat / Masakan Asia",
    "name": "Sop Lezat",
    "description": "Sebuah hidangan istimewa yang dibuat dengan bahan-bahan pilihan, menghasilkan cita rasa yang tak terlupakan."
  },
  {
    "id": 381,
    "basePrice": 151000,
    "category": "Makanan",
    "isBestSeller": false,
    "variants": [
      {
        "id": "381-default",
        "stock": 28,
        "image": "https://images.unsplash.com/photo-1546069901-ba9599a7e63c?w=500"
      }
    ],
    "addons": [],
    "condimentGroups": [
      {
        "id": "condiment-381-1",
        "title": "Pilih Tingkat Pedas",
        "type": "radio",
        "isRequired": true,
        "options": [
          {
            "name": "Tidak Pedas",
            "price": 0
          },
          {
            "name": "Sedang",
            "price": 0
          },
          {
            "name": "Sangat Pedas",
            "price": 1000
          }
        ]
      },
      {
        "id": "condiment-381-2",
        "title": "Topping Tambahan",
        "type": "checkbox",
        "isRequired": false,
        "options": [
          {
            "name": "Bawang Goreng",
            "price": 1000
          },
          {
            "name": "Kerupuk",
            "price": 2000
          }
        ]
      }
    ],
    "brand": "Koki Hebat / Roti",
    "name": "Nasi Juara",
    "description": "Sebuah hidangan istimewa yang dibuat dengan bahan-bahan pilihan, menghasilkan cita rasa yang tak terlupakan."
  },
  {
    "id": 382,
    "basePrice": 69700,
    "category": "Minuman",
    "isBestSeller": false,
    "variants": [
      {
        "id": "382-Hot",
        "temp": "Panas",
        "stock": 18,
        "image": "https://images.unsplash.com/photo-1517256064218-b4f36b544367?w=500"
      },
      {
        "id": "382-Cold",
        "temp": "Dingin",
        "stock": 41,
        "image": "https://images.unsplash.com/photo-1551030172-1353e659b52a?w=500"
      }
    ],
    "addons": [],
    "condimentGroups": [],
    "brand": "Fresh Brews / Jus",
    "name": "Jus Segar",
    "description": "Minuman segar yang dibuat dari bahan-bahan berkualitas untuk mencerahkan harimu."
  },
  {
    "id": 383,
    "basePrice": 41700,
    "category": "Elektronik",
    "isBestSeller": false,
    "variants": [
      {
        "id": "383-default",
        "stock": 12,
        "image": "https://images.unsplash.com/photo-1525547719571-a2d4ac8945e2?w=500"
      }
    ],
    "addons": [
      {
        "id": "addon-383-1",
        "name": "Garansi Ekstra 1 Tahun",
        "price": 120000
      },
      {
        "id": "addon-383-2",
        "name": "Casing Pelindung",
        "price": 190000
      }
    ],
    "condimentGroups": [],
    "brand": "Quantum Tech / Komputer",
    "name": "Power Hub",
    "description": "Perangkat elektronik canggih untuk menunjang produktivitas dan gaya hidup modern Anda."
  },
  {
    "id": 384,
    "basePrice": 389500,
    "category": "Elektronik",
    "isBestSeller": false,
    "variants": [
      {
        "id": "384-default",
        "stock": 6,
        "image": "https://images.unsplash.com/photo-1525547719571-a2d4ac8945e2?w=500"
      }
    ],
    "addons": [],
    "condimentGroups": [],
    "brand": "Quantum Tech / Komputer",
    "name": "Smart Device",
    "description": "Perangkat elektronik canggih untuk menunjang produktivitas dan gaya hidup modern Anda."
  },
  {
    "id": 385,
    "basePrice": 66900,
    "category": "Fashion",
    "isBestSeller": false,
    "variants": [
      {
        "id": "385-Hijau-XL",
        "color": "Hijau",
        "size": "XL",
        "stock": 25,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "385-Hijau-L",
        "color": "Hijau",
        "size": "L",
        "stock": 9,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "385-Biru-M",
        "color": "Biru",
        "size": "M",
        "stock": 2,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "385-Biru-XL",
        "color": "Biru",
        "size": "XL",
        "stock": 12,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "385-Biru-S",
        "color": "Biru",
        "size": "S",
        "stock": 27,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "385-Merah-M",
        "color": "Merah",
        "size": "M",
        "stock": 25,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "385-Merah-L",
        "color": "Merah",
        "size": "L",
        "stock": 13,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      }
    ],
    "addons": [],
    "condimentGroups": [],
    "brand": "Urban Threads / Outerwear",
    "name": "Jaket Modern",
    "description": "Tampil gaya dan percaya diri dengan koleksi fashion terbaru kami yang berkualitas tinggi."
  },
  {
    "id": 386,
    "basePrice": 309600,
    "category": "Minuman",
    "isBestSeller": false,
    "variants": [
      {
        "id": "386-default",
        "stock": 41,
        "image": "https://images.unsplash.com/photo-1551030172-1353e659b52a?w=500"
      }
    ],
    "addons": [],
    "condimentGroups": [],
    "brand": "Fresh Brews / Kopi",
    "name": "Teh Segar",
    "description": "Minuman segar yang dibuat dari bahan-bahan berkualitas untuk mencerahkan harimu."
  },
  {
    "id": 387,
    "basePrice": 457200,
    "category": "Fashion",
    "isBestSeller": false,
    "variants": [
      {
        "id": "387-Hitam-S",
        "color": "Hitam",
        "size": "S",
        "stock": 29,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "387-Hitam-XL",
        "color": "Hitam",
        "size": "XL",
        "stock": 5,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "387-Hitam-L",
        "color": "Hitam",
        "size": "L",
        "stock": 0,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "387-Hitam-M",
        "color": "Hitam",
        "size": "M",
        "stock": 8,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "387-Hijau-L",
        "color": "Hijau",
        "size": "L",
        "stock": 20,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "387-Hijau-XL",
        "color": "Hijau",
        "size": "XL",
        "stock": 21,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "387-Hijau-S",
        "color": "Hijau",
        "size": "S",
        "stock": 14,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      }
    ],
    "addons": [],
    "condimentGroups": [],
    "brand": "Urban Threads / Outerwear",
    "name": "Jaket Eksklusif",
    "description": "Tampil gaya dan percaya diri dengan koleksi fashion terbaru kami yang berkualitas tinggi."
  },
  {
    "id": 388,
    "basePrice": 88900,
    "category": "Minuman",
    "isBestSeller": false,
    "variants": [
      {
        "id": "388-default",
        "stock": 27,
        "image": "https://images.unsplash.com/photo-1551030172-1353e659b52a?w=500"
      }
    ],
    "addons": [],
    "condimentGroups": [],
    "brand": "Fresh Brews / Kopi",
    "name": "Jus Spesial",
    "description": "Minuman segar yang dibuat dari bahan-bahan berkualitas untuk mencerahkan harimu."
  },
  {
    "id": 389,
    "basePrice": 414500,
    "category": "Minuman",
    "isBestSeller": false,
    "variants": [
      {
        "id": "389-default",
        "stock": 22,
        "image": "https://images.unsplash.com/photo-1551030172-1353e659b52a?w=500"
      }
    ],
    "addons": [],
    "condimentGroups": [],
    "brand": "Fresh Brews / Jus",
    "name": "Jus Segar",
    "description": "Minuman segar yang dibuat dari bahan-bahan berkualitas untuk mencerahkan harimu."
  },
  {
    "id": 390,
    "basePrice": 111800,
    "category": "Elektronik",
    "isBestSeller": false,
    "variants": [
      {
        "id": "390-default",
        "stock": 25,
        "image": "https://images.unsplash.com/photo-1525547719571-a2d4ac8945e2?w=500"
      }
    ],
    "addons": [
      {
        "id": "addon-390-1",
        "name": "Garansi Ekstra 1 Tahun",
        "price": 60000
      },
      {
        "id": "addon-390-2",
        "name": "Casing Pelindung",
        "price": 300000
      }
    ],
    "condimentGroups": [],
    "brand": "Quantum Tech / Wearable",
    "name": "Smart Device",
    "description": "Perangkat elektronik canggih untuk menunjang produktivitas dan gaya hidup modern Anda."
  },
  {
    "id": 391,
    "basePrice": 393300,
    "category": "Elektronik",
    "isBestSeller": false,
    "variants": [
      {
        "id": "391-default",
        "stock": 7,
        "image": "https://images.unsplash.com/photo-1525547719571-a2d4ac8945e2?w=500"
      }
    ],
    "addons": [
      {
        "id": "addon-391-1",
        "name": "Garansi Ekstra 1 Tahun",
        "price": 60000
      },
      {
        "id": "addon-391-2",
        "name": "Casing Pelindung",
        "price": 140000
      }
    ],
    "condimentGroups": [],
    "brand": "Quantum Tech / Audio",
    "name": "Smart Device",
    "description": "Perangkat elektronik canggih untuk menunjang produktivitas dan gaya hidup modern Anda."
  },
  {
    "id": 392,
    "basePrice": 241000,
    "category": "Elektronik",
    "isBestSeller": false,
    "variants": [
      {
        "id": "392-default",
        "stock": 14,
        "image": "https://images.unsplash.com/photo-1525547719571-a2d4ac8945e2?w=500"
      }
    ],
    "addons": [],
    "condimentGroups": [],
    "brand": "Quantum Tech / Komputer",
    "name": "Data Device",
    "description": "Perangkat elektronik canggih untuk menunjang produktivitas dan gaya hidup modern Anda."
  },
  {
    "id": 393,
    "basePrice": 494600,
    "category": "Fashion",
    "isBestSeller": false,
    "variants": [
      {
        "id": "393-Hijau-L",
        "color": "Hijau",
        "size": "L",
        "stock": 1,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "393-Hijau-M",
        "color": "Hijau",
        "size": "M",
        "stock": 27,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "393-Hijau-S",
        "color": "Hijau",
        "size": "S",
        "stock": 24,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "393-Hijau-XL",
        "color": "Hijau",
        "size": "XL",
        "stock": 22,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      }
    ],
    "addons": [],
    "condimentGroups": [],
    "brand": "Urban Threads / Casual",
    "name": "Jaket Vintage",
    "description": "Tampil gaya dan percaya diri dengan koleksi fashion terbaru kami yang berkualitas tinggi."
  },
  {
    "id": 394,
    "basePrice": 475700,
    "category": "Minuman",
    "isBestSeller": false,
    "variants": [
      {
        "id": "394-default",
        "stock": 31,
        "image": "https://images.unsplash.com/photo-1551030172-1353e659b52a?w=500"
      }
    ],
    "addons": [
      {
        "id": "addon-394-1",
        "name": "Ekstra Gula",
        "price": 1000
      }
    ],
    "condimentGroups": [],
    "brand": "Fresh Brews / Kopi",
    "name": "Kopi Segar",
    "description": "Minuman segar yang dibuat dari bahan-bahan berkualitas untuk mencerahkan harimu."
  },
  {
    "id": 395,
    "basePrice": 302000,
    "category": "Minuman",
    "isBestSeller": false,
    "variants": [
      {
        "id": "395-default",
        "stock": 37,
        "image": "https://images.unsplash.com/photo-1551030172-1353e659b52a?w=500"
      }
    ],
    "addons": [
      {
        "id": "addon-395-1",
        "name": "Ekstra Gula",
        "price": 1000
      }
    ],
    "condimentGroups": [],
    "brand": "Fresh Brews / Kopi",
    "name": "Jus Mantap",
    "description": "Minuman segar yang dibuat dari bahan-bahan berkualitas untuk mencerahkan harimu."
  },
  {
    "id": 396,
    "basePrice": 408500,
    "category": "Elektronik",
    "isBestSeller": false,
    "variants": [
      {
        "id": "396-default",
        "stock": 22,
        "image": "https://images.unsplash.com/photo-1525547719571-a2d4ac8945e2?w=500"
      }
    ],
    "addons": [
      {
        "id": "addon-396-1",
        "name": "Garansi Ekstra 1 Tahun",
        "price": 170000
      },
      {
        "id": "addon-396-2",
        "name": "Casing Pelindung",
        "price": 170000
      }
    ],
    "condimentGroups": [],
    "brand": "Quantum Tech / Aksesoris",
    "name": "Power Pro",
    "description": "Perangkat elektronik canggih untuk menunjang produktivitas dan gaya hidup modern Anda."
  },
  {
    "id": 397,
    "basePrice": 22600,
    "category": "Makanan",
    "isBestSeller": false,
    "variants": [
      {
        "id": "397-default",
        "stock": 49,
        "image": "https://images.unsplash.com/photo-1546069901-ba9599a7e63c?w=500"
      }
    ],
    "addons": [],
    "condimentGroups": [
      {
        "id": "condiment-397-1",
        "title": "Pilih Tingkat Pedas",
        "type": "radio",
        "isRequired": true,
        "options": [
          {
            "name": "Tidak Pedas",
            "price": 0
          },
          {
            "name": "Sedang",
            "price": 0
          },
          {
            "name": "Sangat Pedas",
            "price": 1000
          }
        ]
      },
      {
        "id": "condiment-397-2",
        "title": "Topping Tambahan",
        "type": "checkbox",
        "isRequired": false,
        "options": [
          {
            "name": "Bawang Goreng",
            "price": 1000
          },
          {
            "name": "Kerupuk",
            "price": 2000
          }
        ]
      }
    ],
    "brand": "Koki Hebat / Masakan Asia",
    "name": "Sate Juara",
    "description": "Sebuah hidangan istimewa yang dibuat dengan bahan-bahan pilihan, menghasilkan cita rasa yang tak terlupakan."
  },
  {
    "id": 398,
    "basePrice": 439700,
    "category": "Minuman",
    "isBestSeller": false,
    "variants": [
      {
        "id": "398-Hot",
        "temp": "Panas",
        "stock": 48,
        "image": "https://images.unsplash.com/photo-1517256064218-b4f36b544367?w=500"
      },
      {
        "id": "398-Cold",
        "temp": "Dingin",
        "stock": 35,
        "image": "https://images.unsplash.com/photo-1551030172-1353e659b52a?w=500"
      }
    ],
    "addons": [],
    "condimentGroups": [],
    "brand": "Fresh Brews / Kopi",
    "name": "Teh Spesial",
    "description": "Minuman segar yang dibuat dari bahan-bahan berkualitas untuk mencerahkan harimu."
  },
  {
    "id": 399,
    "basePrice": 195900,
    "category": "Fashion",
    "isBestSeller": false,
    "variants": [
      {
        "id": "399-Hijau-XL",
        "color": "Hijau",
        "size": "XL",
        "stock": 15,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "399-Hijau-L",
        "color": "Hijau",
        "size": "L",
        "stock": 10,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "399-Hijau-S",
        "color": "Hijau",
        "size": "S",
        "stock": 27,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      },
      {
        "id": "399-Hijau-M",
        "color": "Hijau",
        "size": "M",
        "stock": 25,
        "image": "https://images.unsplash.com/photo-1521572163474-6864f9cf17ab?w=500"
      }
    ],
    "addons": [],
    "condimentGroups": [],
    "brand": "Urban Threads / Active",
    "name": "Kemeja Modern",
    "description": "Tampil gaya dan percaya diri dengan koleksi fashion terbaru kami yang berkualitas tinggi."
  }
];